!Object constantsFor: 'Geos Libraries'!

geosLIB73 'SYSTEM\ssset'! !

!Object constantsFor: 'Geos vardata'!

attrBarringCallType 27648!
attrBarringQueryAnswered 27652!
attrDivertingCallType 27648!
attrDivertingShowVmbxErrorNote 27652!
attrWaitingCallType 27648!
!

!Object constantsFor: 'Geos messages'!

applyAllOut 27648!
applyIntOut 27649!
applyIntXHomeOut 27650!
applyAllIn 27651!
applyInIfAbroad 27652!
applyGetStatus 27653!
applyClearAll 27654!
applyClose 27655!
applyCancelRequest 27656!
getNetworkPasswd 27657!
applyNetworkPasswd 27658!
eciStatus 27659!
updateTitle 27660!
alternateLineSelected 27661!
getCallType 27662!
applyUncond 27648!
applyBusy 27649!
applyNoReply 27650!
applyNotReachable 27651!
cancelUncond 27652!
cancelBusy 27653!
cancelNoReply 27654!
cancelNotReachable 27655!
applyGetStatus 27656!
applyClearAll 27657!
applyClose 27658!
applyCancelRequest 27659!
getVmbNumber 27660!
applyVmbNumber 27661!
vmbStatus 27662!
eciStatus 27663!
updateTitle 27664!
alternateLineSelected 27665!
getCallType 27666!
apply 27648!
applyGetStatus 27649!
applyClose 27650!
applyCancelRequest 27651!
eciStatus 27652!
!

!Geos class methodsFor: 'library calls'!

!

GenControl subclass: #CBarring
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #CDiverting
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #CWaiting
	instanceVariableNames: ''
	classVariableNames: ''!

!CBarring comment!
Library ssset, file internal/resp/ssset.goh! !

!CBarring class methodsFor: 'library linkage'!

library
	^73!

entry
	^0001!
!

!CBarring methodsFor: 'Geos instance variables'!

cbiQueryActive
	"@instance Boolean CBI_queryActive"
	^self wordAt: 25!

cbiQueryActive: value
	"@instance Boolean CBI_queryActive"
	^self wordAt: 25 put: value!

cbiRequestId
	"@instance byte CBI_requestId"
	^self byteAt: 27!

cbiRequestId: value
	"@instance byte CBI_requestId"
	^self byteAt: 27 put: value!

cbciControlObj
	"@instance optr CBCI_controlObj"
	^self dwordAt: 28!

cbciControlObj: value
	"@instance optr CBCI_controlObj"
	^self dwordAt: 28 put: value!

!

!CBarring methodsFor: 'Geos vardata'!

attrBarringCallType: value
	"@vardata SSSetCallType ATTR_BARRING_CALL_TYPE"
	^self addVardata: ##attrBarringCallType byte: value!

attrBarringQueryAnswered: value
	"@vardata Boolean ATTR_BARRING_QUERY_ANSWERED"
	^self addVardata: ##attrBarringQueryAnswered word: value!

!

!CBarring methodsFor: 'Geos messages'!

applyAllOut: selection with: numSelections with: stateFlags
	"@message void MSG_BARRING_APPLY_ALL_OUT( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 0 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyIntOut: selection with: numSelections with: stateFlags
	"@message void MSG_BARRING_APPLY_INT_OUT( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 1 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyIntXHomeOut: selection with: numSelections with: stateFlags
	"@message void MSG_BARRING_APPLY_INT_X_HOME_OUT( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 2 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyAllIn: selection with: numSelections with: stateFlags
	"@message void MSG_BARRING_APPLY_ALL_IN( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 3 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyInIfAbroad: selection with: numSelections with: stateFlags
	"@message void MSG_BARRING_APPLY_IN_IF_ABROAD( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 4 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyGetStatus
	"@message void MSG_BARRING_APPLY_GET_STATUS()"
	^self geosMessage: #[108 5 2 0 0]!

applyClearAll
	"@message void MSG_BARRING_APPLY_CLEAR_ALL()"
	^self geosMessage: #[108 6 2 0 0]!

applyClose
	"@message void MSG_BARRING_APPLY_CLOSE()"
	^self geosMessage: #[108 7 2 0 0]!

applyCancelRequest
	"@message void MSG_BARRING_APPLY_CANCEL_REQUEST()"
	^self geosMessage: #[108 8 2 0 0]!

getNetworkPasswd
	"@message void MSG_BARRING_GET_NETWORK_PASSWD()"
	^self geosMessage: #[108 9 2 0 0]!

applyNetworkPasswd: command
	"@message void MSG_BARRING_APPLY_NETWORK_PASSWD( byte command)"
	^self geosMessage: #[108 10 1 0 1 0] with: command!

eciStatus: messageId with: structure
	"@message void MSG_BARRING_ECI_STATUS( word messageId, MemHandle structure)"
	^self geosMessage: #[108 11 1 0 1 1 0] with: messageId with: structure!

updateTitle
	"@message void MSG_BARRING_UPDATE_TITLE()"
	^self geosMessage: #[108 12 2 0 0]!

alternateLineSelected
	"@message Boolean MSG_BARRING_ALTERNATE_LINE_SELECTED()"
	^self geosMessage: #[108 13 2 0 4]!

getCallType
	"@message SSSetCallType MSG_BARRING_GET_CALL_TYPE()"
	^self geosMessage: #[108 14 2 0 1]!

!

!CDiverting comment!
Library ssset, file internal/resp/ssset.goh! !

!CDiverting class methodsFor: 'library linkage'!

library
	^73!

entry
	^0000!
!

!CDiverting methodsFor: 'Geos instance variables'!

cdiVmbNumber
	"@instance TCHAR[31] CDI_vmbNumber"
	"#pointer [25, 31]"
	^self!

cdiQueryActive
	"@instance Boolean CDI_queryActive"
	^self wordAt: 56!

cdiQueryActive: value
	"@instance Boolean CDI_queryActive"
	^self wordAt: 56 put: value!

cdiVmbxQueryActive
	"@instance Boolean CDI_vmbxQueryActive"
	^self wordAt: 58!

cdiVmbxQueryActive: value
	"@instance Boolean CDI_vmbxQueryActive"
	^self wordAt: 58 put: value!

cdiRequestId
	"@instance byte CDI_requestId"
	^self byteAt: 60!

cdiRequestId: value
	"@instance byte CDI_requestId"
	^self byteAt: 60 put: value!

cdciControlObj
	"@instance optr CDCI_controlObj"
	^self dwordAt: 61!

cdciControlObj: value
	"@instance optr CDCI_controlObj"
	^self dwordAt: 61 put: value!

!

!CDiverting methodsFor: 'Geos vardata'!

attrDivertingCallType: value
	"@vardata SSSetCallType ATTR_DIVERTING_CALL_TYPE"
	^self addVardata: ##attrDivertingCallType byte: value!

attrDivertingShowVmbxErrorNote
	"@vardata void ATTR_DIVERTING_SHOW_VMBX_ERROR_NOTE"
	^self addVardata: ##attrDivertingShowVmbxErrorNote!

!

!CDiverting methodsFor: 'Geos messages'!

applyUncond: selection with: numSelections with: stateFlags
	"@message void MSG_DIVERTING_APPLY_UNCOND( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 0 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyBusy: selection with: numSelections with: stateFlags
	"@message void MSG_DIVERTING_APPLY_BUSY( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 1 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyNoReply: selection with: numSelections with: stateFlags
	"@message void MSG_DIVERTING_APPLY_NO_REPLY( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 2 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyNotReachable: selection with: numSelections with: stateFlags
	"@message void MSG_DIVERTING_APPLY_NOT_REACHABLE( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 3 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

cancelUncond
	"@message void MSG_DIVERTING_CANCEL_UNCOND()"
	^self geosMessage: #[108 4 2 0 0]!

cancelBusy
	"@message void MSG_DIVERTING_CANCEL_BUSY()"
	^self geosMessage: #[108 5 2 0 0]!

cancelNoReply
	"@message void MSG_DIVERTING_CANCEL_NO_REPLY()"
	^self geosMessage: #[108 6 2 0 0]!

cancelNotReachable
	"@message void MSG_DIVERTING_CANCEL_NOT_REACHABLE()"
	^self geosMessage: #[108 7 2 0 0]!

applyGetStatus
	"@message void MSG_DIVERTING_APPLY_GET_STATUS()"
	^self geosMessage: #[108 8 2 0 0]!

applyClearAll
	"@message void MSG_DIVERTING_APPLY_CLEAR_ALL()"
	^self geosMessage: #[108 9 2 0 0]!

applyClose
	"@message void MSG_DIVERTING_APPLY_CLOSE()"
	^self geosMessage: #[108 10 2 0 0]!

applyCancelRequest
	"@message void MSG_DIVERTING_APPLY_CANCEL_REQUEST()"
	^self geosMessage: #[108 11 2 0 0]!

getVmbNumber
	"@message void MSG_DIVERTING_GET_VMB_NUMBER()"
	^self geosMessage: #[108 12 2 0 0]!

applyVmbNumber: command
	"@message void MSG_DIVERTING_APPLY_VMB_NUMBER( byte command)"
	^self geosMessage: #[108 13 1 0 1 0] with: command!

vmbStatus: messageId with: structure
	"@message void MSG_DIVERTING_VMB_STATUS( word messageId, MemHandle structure)"
	^self geosMessage: #[108 14 1 0 1 1 0] with: messageId with: structure!

eciStatus: messageId with: structure
	"@message void MSG_DIVERTING_ECI_STATUS( word messageId, MemHandle structure)"
	^self geosMessage: #[108 15 1 0 1 1 0] with: messageId with: structure!

updateTitle
	"@message void MSG_DIVERTING_UPDATE_TITLE()"
	^self geosMessage: #[108 16 2 0 0]!

alternateLineSelected
	"@message Boolean MSG_DIVERTING_ALTERNATE_LINE_SELECTED()"
	^self geosMessage: #[108 17 2 0 4]!

getCallType
	"@message SSSetCallType MSG_DIVERTING_GET_CALL_TYPE()"
	^self geosMessage: #[108 18 2 0 1]!

!

!CWaiting comment!
Library ssset, file internal/resp/ssset.goh! !

!CWaiting class methodsFor: 'library linkage'!

library
	^73!

entry
	^0002!
!

!CWaiting methodsFor: 'Geos instance variables'!

cwiQueryActive
	"@instance Boolean CWI_queryActive"
	^self wordAt: 25!

cwiQueryActive: value
	"@instance Boolean CWI_queryActive"
	^self wordAt: 25 put: value!

cwciControlObj
	"@instance optr CWCI_controlObj"
	^self dwordAt: 27!

cwciControlObj: value
	"@instance optr CWCI_controlObj"
	^self dwordAt: 27 put: value!

!

!CWaiting methodsFor: 'Geos vardata'!

attrWaitingCallType: value
	"@vardata SSSetCallType ATTR_WAITING_CALL_TYPE"
	^self addVardata: ##attrWaitingCallType byte: value!

!

!CWaiting methodsFor: 'Geos messages'!

apply: selection with: numSelections with: stateFlags
	"@message void MSG_WAITING_APPLY( word selection = cx, word numSelections = bp, GenItemGroupStateFlags stateFlags = dl)"
	^self geosMessage: #[108 0 2 253 1 1 1 0] with: selection with: numSelections with: stateFlags!

applyGetStatus
	"@message void MSG_WAITING_APPLY_GET_STATUS()"
	^self geosMessage: #[108 1 2 0 0]!

applyClose
	"@message void MSG_WAITING_APPLY_CLOSE()"
	^self geosMessage: #[108 2 2 0 0]!

applyCancelRequest
	"@message void MSG_WAITING_APPLY_CANCEL_REQUEST()"
	^self geosMessage: #[108 3 2 0 0]!

eciStatus: messageId with: structure
	"@message void MSG_WAITING_ECI_STATUS( word messageId, MemHandle structure)"
	^self geosMessage: #[108 4 1 0 1 1 0] with: messageId with: structure!

!

